#ifndef UTIL_H
#define UTIL_H

#include <string>
#include <vector>

typedef unsigned char byte;
string checkmac(const char* mac);

class DebugPrint {
	protected:
		int level;
		string prefix;
	
	public:
		enum level_t { error = 0, warning, normal, verbose, debug, debug2 };

		DebugPrint(string prefix = string(), level_t level = normal) ;
		void setLevel(int level);
		void setLevel(level_t level);
		int getLevel() { return level; }
		void setPrefix(string prefix) { this->prefix = prefix; }
		string getPrefix() { return prefix; }
		void printError(const char* fmt, ...);  // print errors on stderr
		void printWarning(const char* fmt, ...);  // print warnings on stdout
		void print(const char* fmt, ...); // nomal messages on stdout
		void printVerbose(const char* fmt, ...);
		void printDebug(const char* fmt, ...);
		void printDebug2(const char* fmt, ...);
		string printVector(char* prefix, const vector<byte>& vec, string delimiter = "");
		string printVector(char* prefix, byte *vec, int N, string delimiter = "");
};

class CRC32 {
	private:
		unsigned int crc;
		unsigned int counter;

		unsigned char swap8(unsigned char);
		unsigned int swap32(unsigned int);
	public:
		CRC32() { Init(); }
		void Init();
		void Update(char data);
		void Update(char* data, int len);
		void Finish();
		unsigned int getCRC() { return swap32(crc); }
		unsigned char operator[] (int);
};

#endif
