# Script to read web based file, add col.names, add title & plot note, produce XYPlot
## STEP 1: SETUP
   setwd("C:/Download")
   library(lattice)
   link <-url("ftp://ftp.cmdl.noaa.gov/ccg/co2/trends/co2_mm_mlo.txt")
## STEP 2: READ DATA
   CO2_Data <- read.table(link,
             sep = "",
             dec=".",
             skip = 68,
             row.names = NULL,
             header = FALSE,
             colClasses <- rep("numeric",6),
             na.strings = -99.99,
             col.names <- c("Yr", "Mo", "Mo_Yr", "CO2", "Trnd", "X", "d") )
## STEP 3: MANIPULATE DATA
   c <- nrow(CO2_Data)                    # Find number of data rows
   mo <- CO2_Data$Mo[c]                   # Find month for last data row
   yr <- CO2_Data$Yr[c]                   # Find year for last data row
   thru <-   paste("Updated Through:", mo,"/",yr)   # Note on last data point
   Title <- expression(paste("Monthly C", O[2], " (ppmv) - Mana Loa, Hawaii"))
## STEP 4: CREATE PLOT
   xyplot(CO2 ~ Mo_Yr, CO2_Data,
         ylim = c(300,400),
         xlim = c(1958, 2012),
         type="1",
         col = "red",
         xlab = "",
         ylab = expression(paste(CO[2] - ppmv)),
         main = Title,
         sub = thru,
         par.settings=list(axis.text=list(cex=0.8), fontsize=list(text=10)),
         aspect = "xy")