############## RClimate Script: NINO 3.4 SSTA            ###################################
## Script stored on http://chartsgraphs.wordpress.com account for Users to source()       ##                                                                                       ## 
## Download and process Weekly NINO3.4 SSTA                                               ##
## Developed by D Kelly O'Day to demonstrate use of source() function for climate data    ##
##                   http:chartsgraphs.wordpress.com    1/28/10                           ##
############################################################################################
## set plot pars
 par(ps=10); par(las=1); par(oma=c(2.5,1,3,1)); par(mar=c(2,4,2,0))

## set link & read data
 link <- "http://www.cpc.noaa.gov/data/indices/wksst.for"
 nino_34 <- read.fwf(link, widths=c(10,-31,4,4,-17),skip = 4, header=F)
 names(nino_34) <- c("cdt", "sst", "ssta")

## calc yr_frac
 dt <- as.Date(nino_34$cdt, format="%d%b%Y")
 yr <- as.numeric(format(dt, format="%Y"))
 mo <- as.numeric(format(dt, format="%m"))
 dy <- as.numeric(format(dt, format="%d"))
 yr_frac <- as.numeric(yr + (mo-1)/12 + (dy/30)/12)
 
 nino_34 <- data.frame(dt,yr_frac,  nino_34[,2:3])

## Determine Month, Year for last reading
   c <- nrow(nino_34)                    # Find number of data rows
   ldt <- nino_34[c,1] 
   l_yr_frac <- nino_34[c,2]
   l_nino_34 <- nino_34[c,4]
   lp_note <- paste(ldt, " @ ",l_nino_34,"C",sep="")

## subset data to add color for LaNina & El Nino cnditions
  la_nina <- subset(nino_34, ssta < 0)
  el_nino <- subset(nino_34, ssta>= 0)

## Plot titles
  title = "NINO 3.4 SST Anomaly - Weekly Trends\n NOAA - Data Centered on Wed"
  y_lab <- expression(paste("Anomaly - ",degree,"C", sep=""))

p_fun <- function() {
plot(nino_34$yr_frac, nino_34$ssta, type = "n", main=title, xlab="", ylab = y_lab,
   cex.main=0.85, cex.lab=0.85)
  points(la_nina$yr_frac, lanina$ssta, col = "blue", type = "h")
  points(el_nino$yr_frac, elnino$ssta, col = "red", type = "h")
  points(l_yr_frac, l_nino_34, pch=19, col = "black",cex=0.75)
  points(1991.5, -2, pch=19, col="black", cex=0.75)
  text (1992, -2, lp_note, adj=0, cex=0.8)
## Generate and add bottom footer KOD, source, System date notes
  source_note <- paste("Data Source: ", link)
  mtext("D Kelly O'Day - http://chartgraphs.wordpress.com", 1,1, adj = 0, cex = 0.8, outer=TRUE)
  mtext(format(Sys.time(), "%m/%d/ %Y"), 1, 1, adj = 1, cex = 0.8, outer=TRUE)
  mtext(source_note, 1,0,adj=0.5, cex=0.8, outer=T)
  }

## plot trend to console
  p_fun()

 tail(nino_34)

